<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MyBusinessLodging;

class SustainableSourcing extends \Google\Model
{
  /**
   * @var bool
   */
  public $ecoFriendlyToiletries;
  /**
   * @var string
   */
  public $ecoFriendlyToiletriesException;
  /**
   * @var bool
   */
  public $locallySourcedFoodAndBeverages;
  /**
   * @var string
   */
  public $locallySourcedFoodAndBeveragesException;
  /**
   * @var bool
   */
  public $organicCageFreeEggs;
  /**
   * @var string
   */
  public $organicCageFreeEggsException;
  /**
   * @var bool
   */
  public $organicFoodAndBeverages;
  /**
   * @var string
   */
  public $organicFoodAndBeveragesException;
  /**
   * @var bool
   */
  public $responsiblePurchasingPolicy;
  /**
   * @var string
   */
  public $responsiblePurchasingPolicyException;
  /**
   * @var bool
   */
  public $responsiblySourcesSeafood;
  /**
   * @var string
   */
  public $responsiblySourcesSeafoodException;
  /**
   * @var bool
   */
  public $veganMeals;
  /**
   * @var string
   */
  public $veganMealsException;
  /**
   * @var bool
   */
  public $vegetarianMeals;
  /**
   * @var string
   */
  public $vegetarianMealsException;

  /**
   * @param bool
   */
  public function setEcoFriendlyToiletries($ecoFriendlyToiletries)
  {
    $this->ecoFriendlyToiletries = $ecoFriendlyToiletries;
  }
  /**
   * @return bool
   */
  public function getEcoFriendlyToiletries()
  {
    return $this->ecoFriendlyToiletries;
  }
  /**
   * @param string
   */
  public function setEcoFriendlyToiletriesException($ecoFriendlyToiletriesException)
  {
    $this->ecoFriendlyToiletriesException = $ecoFriendlyToiletriesException;
  }
  /**
   * @return string
   */
  public function getEcoFriendlyToiletriesException()
  {
    return $this->ecoFriendlyToiletriesException;
  }
  /**
   * @param bool
   */
  public function setLocallySourcedFoodAndBeverages($locallySourcedFoodAndBeverages)
  {
    $this->locallySourcedFoodAndBeverages = $locallySourcedFoodAndBeverages;
  }
  /**
   * @return bool
   */
  public function getLocallySourcedFoodAndBeverages()
  {
    return $this->locallySourcedFoodAndBeverages;
  }
  /**
   * @param string
   */
  public function setLocallySourcedFoodAndBeveragesException($locallySourcedFoodAndBeveragesException)
  {
    $this->locallySourcedFoodAndBeveragesException = $locallySourcedFoodAndBeveragesException;
  }
  /**
   * @return string
   */
  public function getLocallySourcedFoodAndBeveragesException()
  {
    return $this->locallySourcedFoodAndBeveragesException;
  }
  /**
   * @param bool
   */
  public function setOrganicCageFreeEggs($organicCageFreeEggs)
  {
    $this->organicCageFreeEggs = $organicCageFreeEggs;
  }
  /**
   * @return bool
   */
  public function getOrganicCageFreeEggs()
  {
    return $this->organicCageFreeEggs;
  }
  /**
   * @param string
   */
  public function setOrganicCageFreeEggsException($organicCageFreeEggsException)
  {
    $this->organicCageFreeEggsException = $organicCageFreeEggsException;
  }
  /**
   * @return string
   */
  public function getOrganicCageFreeEggsException()
  {
    return $this->organicCageFreeEggsException;
  }
  /**
   * @param bool
   */
  public function setOrganicFoodAndBeverages($organicFoodAndBeverages)
  {
    $this->organicFoodAndBeverages = $organicFoodAndBeverages;
  }
  /**
   * @return bool
   */
  public function getOrganicFoodAndBeverages()
  {
    return $this->organicFoodAndBeverages;
  }
  /**
   * @param string
   */
  public function setOrganicFoodAndBeveragesException($organicFoodAndBeveragesException)
  {
    $this->organicFoodAndBeveragesException = $organicFoodAndBeveragesException;
  }
  /**
   * @return string
   */
  public function getOrganicFoodAndBeveragesException()
  {
    return $this->organicFoodAndBeveragesException;
  }
  /**
   * @param bool
   */
  public function setResponsiblePurchasingPolicy($responsiblePurchasingPolicy)
  {
    $this->responsiblePurchasingPolicy = $responsiblePurchasingPolicy;
  }
  /**
   * @return bool
   */
  public function getResponsiblePurchasingPolicy()
  {
    return $this->responsiblePurchasingPolicy;
  }
  /**
   * @param string
   */
  public function setResponsiblePurchasingPolicyException($responsiblePurchasingPolicyException)
  {
    $this->responsiblePurchasingPolicyException = $responsiblePurchasingPolicyException;
  }
  /**
   * @return string
   */
  public function getResponsiblePurchasingPolicyException()
  {
    return $this->responsiblePurchasingPolicyException;
  }
  /**
   * @param bool
   */
  public function setResponsiblySourcesSeafood($responsiblySourcesSeafood)
  {
    $this->responsiblySourcesSeafood = $responsiblySourcesSeafood;
  }
  /**
   * @return bool
   */
  public function getResponsiblySourcesSeafood()
  {
    return $this->responsiblySourcesSeafood;
  }
  /**
   * @param string
   */
  public function setResponsiblySourcesSeafoodException($responsiblySourcesSeafoodException)
  {
    $this->responsiblySourcesSeafoodException = $responsiblySourcesSeafoodException;
  }
  /**
   * @return string
   */
  public function getResponsiblySourcesSeafoodException()
  {
    return $this->responsiblySourcesSeafoodException;
  }
  /**
   * @param bool
   */
  public function setVeganMeals($veganMeals)
  {
    $this->veganMeals = $veganMeals;
  }
  /**
   * @return bool
   */
  public function getVeganMeals()
  {
    return $this->veganMeals;
  }
  /**
   * @param string
   */
  public function setVeganMealsException($veganMealsException)
  {
    $this->veganMealsException = $veganMealsException;
  }
  /**
   * @return string
   */
  public function getVeganMealsException()
  {
    return $this->veganMealsException;
  }
  /**
   * @param bool
   */
  public function setVegetarianMeals($vegetarianMeals)
  {
    $this->vegetarianMeals = $vegetarianMeals;
  }
  /**
   * @return bool
   */
  public function getVegetarianMeals()
  {
    return $this->vegetarianMeals;
  }
  /**
   * @param string
   */
  public function setVegetarianMealsException($vegetarianMealsException)
  {
    $this->vegetarianMealsException = $vegetarianMealsException;
  }
  /**
   * @return string
   */
  public function getVegetarianMealsException()
  {
    return $this->vegetarianMealsException;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SustainableSourcing::class, 'Google_Service_MyBusinessLodging_SustainableSourcing');
